//  File: users.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <22-Sep-2002 14:43:46 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "termin.h"

void readGroups ();
void readUsers ();
void readRooms ();
int maxID(FILE *fp);
void chop(char *t);
void readGroupAdmins ();
int readHoliDays ();
void extendIdSetList (int uid);
void initGroup(int uid, char *name);
void initUser(int uid, char *name, char *full);
void initRoom(int uid, char *name);

char *unknownID="???";

void readLists()
{

 defGroupAdminPerm=511;
 defGroupMembrPerm=143;
 defGroupOtherPerm=3;
 defUserCalPerm=15;
 defRoomCalPerm=15;

 // readDeafults();
 readGroups();
 readUsers();
 readRooms();
 readGroupAdmins();
 readHoliDays();

 if(doCheckPresence)
  {
   if(presenceList !=NULL)
    delete presenceList;
   presenceList = new char [userAnz*16+16];
  }
}

void clearLists ()
{
 int i;
 for(i=0;i<=groupAnz; i++)
  delete groupList[i].cal.list;
 for(i=0;i<=userAnz; i++)
  delete userList[i].cal.list;
 for(i=0;i<roomAnz; i++)
  delete roomList[i].cal.list;

 delete groupList;
 delete userList;
 delete roomList;
}

void initGroup(int id, char *name)
{

 strcpy(groupList[id].name,name);
 groupList[id].id=id;
 groupList[id].anz=0;
 groupList[id].cal.id =id;
 groupList[id].cal.list = new (Date *) [DATEBLOCKSIZE];
 groupList[id].cal.max = DATEBLOCKSIZE;
 groupList[id].cal.anz = 0;
 groupList[id].proj.id =id;
 groupList[id].proj.list = new (Project *) [DATEBLOCKSIZE];
 groupList[id].proj.max = DATEBLOCKSIZE;
 groupList[id].proj.anz = 0;
 groupList[id].todo.id =id;
 groupList[id].todo.list = new (TodoItem *) [DATEBLOCKSIZE];
 groupList[id].todo.max = DATEBLOCKSIZE;
 groupList[id].todo.anz = 0;
 groupList[id].adminPerm = defGroupAdminPerm;
 groupList[id].membrPerm = defGroupMembrPerm;
 groupList[id].otherPerm = defGroupOtherPerm;
 groupList[id].dontList=0;
 strcpy(groupList[id].color,"#000000");
}

void readGroups ()
{
 FILE *fp;
 char file[4096],buffer[16384],*t,*s;
 int ret,id;

 sprintf(file,"%s/groups",dataDir);
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 



 groupAnz=maxID(fp)+1;
 printf("Got %d groups\n",groupAnz);
 groupList =  new Group [groupAnz+1];
 for(id=0;id<=groupAnz;id++)
  groupList[id].id=-1;

 switch(serverLang)
  {
  case MINKO_LANG_DE:  initGroup(0,"Alle"); break;
  case MINKO_LANG_EN:  
  default:             initGroup(0,"All"); break;
  }
 primGroup = 0;

 t = fgets(buffer,16383,fp);
 chop(buffer);
 while(strcmp(buffer,"EOL")!=0 && t!=NULL)
  {
   if(strncmp(buffer,"ID",2)==0)
    {
     id = atoi(buffer+3);
     s=skip2WS(buffer+3);
     s=skip2nonWS(s);
     s=trimRight(s);
     initGroup(id,s);
    }
   else if(groupAnz>=0)
    {
     if (strncmp(buffer,"PERM",4)==0)
      {
       s=skip2nonWS(buffer+4);
       s[9]='\0';
       groupList[id].adminPerm = perm2val(s);
       s=skip2nonWS(s+10);
       s[9]='\0';
       groupList[id].membrPerm = perm2val(s);
       s=skip2nonWS(s+10);
       s[9]='\0';
       groupList[id].otherPerm = perm2val(s);
      }
     if(strncmp(buffer,"DONTLIST",8)==0)
      {
       groupList[id].dontList=1;
      }
     if(strncmp(buffer,"COLOR",5)==0)
      {
       s=skip2nonWS(buffer+6);
       strcpy(groupList[id].color,s);
      }
     if(strncmp(buffer,"PRIMARY",5)==0)
      {
       primGroup = id;
      }
    }
   t = fgets(buffer,16383,fp);
   chop(buffer);
  }
 fclose(fp);
}

void readGroupAdmins ()
{
 FILE *fp;
 char file[4096],buffer[16384],*t,*s,*s2;
 int ret,id,i,uid;

 sprintf(file,"%s/groups",dataDir);
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 t = fgets(buffer,16383,fp);
 chop(buffer);
 while(strcmp(buffer,"EOL")!=0 && t!=NULL)
  {
   if(strncmp(buffer,"ID",2)==0)
    {
     id = atoi(buffer+3);
    }     
   else if(strncmp(buffer,"ADMIN",5)==0)
    {
     s=skip2WS(buffer+5);
     s=skip2nonWS(s);
     while(*s!='\0')
      {
       s2 =skip2WS(s);
       if(s2 !=NULL)
	*s2='\0';
       uid = uname2uid(s);
       for(i=0;i<groupList[id].anz;i++)
	if(groupList[id].membr[i] == uid)
	 {
	  groupList[id].mstat[i]=GROUP_ADMIN;
	  break;
	 }
       if(s2==NULL)
	break;
       s=skip2nonWS(s2+1);
       if(s==NULL)
	break;
      }
    }
   t = fgets(buffer,16383,fp);
   chop(buffer);
  }
 fclose(fp);
}

int perm2val(char *p)
{
 int w,perm=0;
 char *t,*s;

 // t=permStr;
 s=p;
 for(w=1; w<= PERM_ALL; w*=2,t++,s++)
  //  if(*t==*s)
  if(*s!='-')
   perm |= w;
 return(perm);
}
char * perm2str(int v, char *p)
{
 int w,perm=0;
 char *t,*s;

 switch (serverLang)
  {
  case MINKO_LANG_DE:
   t=permStr_de;
  case MINKO_LANG_EN:
  default:
   t=permStr_en;
  }
 s=p;
 for(w=1; w<= PERM_ALL; w*=2,t++,s++)
  if( (v & w) == w)
   *s=*t;
  else
   *s='-';
 *s='\0';
 return(p);
}

void initUser(int id, char *name, char *full)
{

 strcpy(userList[id].name,name);
 strcpy(userList[id].full,full);
 userList[id].id=id;
 userList[id].groups[0]=-1;
 userList[id].cal.id =id;
 userList[id].cal.list = new (Date *) [DATEBLOCKSIZE];
 userList[id].cal.max = DATEBLOCKSIZE;
 userList[id].cal.anz = 0;
 userList[id].proj.id =id;
 userList[id].proj.list = new (Project *) [DATEBLOCKSIZE];
 userList[id].proj.max = DATEBLOCKSIZE;
 userList[id].proj.anz = 0;
 userList[id].todo.id =id;
 userList[id].todo.list = new (TodoItem *) [DATEBLOCKSIZE];
 userList[id].todo.max = DATEBLOCKSIZE;
 userList[id].todo.anz = 0;
 userList[id].gpanz = 0;
 userList[id].mail[0][0] = '\0';
 userList[id].mail[1][0] = '\0';
 userList[id].mail[2][0] = '\0';
 userList[id].mail[3][0] = '\0';
 userList[id].smtp[0][0] = '\0';
 userList[id].smtp[1][0] = '\0';
 userList[id].smtp[2][0] = '\0';
 userList[id].smtp[3][0] = '\0';
 userList[id].sig.cmd=NULL;
 userList[id].lastAction = 0;
 userList[id].displayIgnore   = 0;
 userList[id].displayInfo     = 1;
 userList[id].displayToolTips = 1;
 userList[id].hasNotifier = false;
 userList[id].isNotified  = false;
 strcpy(userList[id].color,"#000000");
 strcpy(userList[id].color2,"#000000");
 userList[id].connectionTime =0;
 userList[id].socket =-1;
 userList[id].rsocket =-1;
 userList[id].ticket =-1;
 userList[id].direction_dateRemind =0;
 userList[id].direction_dateInvite =0;
 userList[id].direction_todoRemind =0;
 userList[id].direction_todoMahn   =0;
 userList[id].idSetMax=0;
 userList[id].idSetAnz=0;
 userList[id].set = NULL;
 userList[id].dontList =0;
 strcpy(userList[id].calFormat,"7 20 3 3 3 2");
 userList[id].presence =false;
 strcpy(userList[id].browser,"minkowsky");
 userList[id].browserCmd[0]='\0';
 
 initDateUserModification(&userList[id]);
 userList[id].dmodiDirty = false;
 
 userList[id].saveCalViewOnLogout=0;
 userList[id].savePrjViewOnLogout=0;
 userList[id].saveAdrViewOnLogout=0;
 userList[id].calView = NULL;
 userList[id].prjView = NULL;
 userList[id].adrView = NULL;

 userList[id].sync              = new syncUserInfo;
 userList[id].sync->ctrl        = NULL;
 userList[id].sync->active      = false;
 userList[id].sync->timeStamp   = 0;
 userList[id].sync->lastCalSync = 0;
 userList[id].sync->lastPrjSync = 0;
 userList[id].sync->lastAdrSync = 0;

 userList[id].syncPref = NULL;
 userList[id].syncAdrPref = NULL;
 userList[id].syncPrjPref = NULL;
 userList[id].syncCalPref = NULL;
 for(int f=0;f<ADR_TAG_ANZ; f++)
  userList[id].sync->csvImportTypeDefault[f] = NULL;

#ifdef WITH_THREADS
 pthread_mutex_init(&userList[id].connectMutex, NULL);
 pthread_mutex_init(&userList[id].reminderMutex, NULL);
#endif
}
void readUsers ()
{
 FILE *fp;
 char file[4096],buffer[16384],*t,*s,*tp[256];
 int ret,id,gid,gc,i,anz,uid;

 sprintf(file,"%s/users",dataDir);
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 

 userAnz=maxID(fp)+1;
 printf("Got %d users\n",userAnz);
 userList =  new User [userAnz+1];
 for(id=0;id<=userAnz;id++)
  userList[id].id=-1;

 switch(serverLang)
  {
  case MINKO_LANG_DE:   initUser(0,"admin","Minkowsky Administrator");
   break;
  case MINKO_LANG_EN:  
  default:             initUser(0,"admin","Minkowsky Administrator");
   break;
  }

 t = fgets(buffer,16383,fp);
 chop(buffer);
 while(strcmp(buffer,"EOL")!=0 && t!=NULL)
  {
   if(strncmp(buffer,"ID",2)==0)
    {
     id = atoi(buffer+3);
     s=skip2WS(buffer+3);
     s=skip2nonWS(s);
     initUser(id,s,"");
     gc=0;
//      strcpy(userList[id].name,s);
//      userList[id].id=id;
//      gc=0;
//      userList[id].groups[0]=-1;
//      userList[id].cal.id =id;
//      userList[id].cal.list = new (Date *) [DATEBLOCKSIZE];
//      userList[id].cal.max = DATEBLOCKSIZE;
//      userList[id].cal.anz = 0;
//      userList[id].proj.id =id;
//      userList[id].proj.list = new (Project *) [DATEBLOCKSIZE];
//      userList[id].proj.max = DATEBLOCKSIZE;
//      userList[id].proj.anz = 0;
//      userList[id].todo.id =id;
//      userList[id].todo.list = new (TodoItem *) [DATEBLOCKSIZE];
//      userList[id].todo.max = DATEBLOCKSIZE;
//      userList[id].todo.anz = 0;
//      userList[id].gpanz = 0;
//      userList[id].mail[0][0] = '\0';
//      userList[id].mail[1][0] = '\0';
//      userList[id].mail[2][0] = '\0';
//      userList[id].mail[3][0] = '\0';
//      userList[id].smtp[0][0] = '\0';
//      userList[id].smtp[1][0] = '\0';
//      userList[id].smtp[2][0] = '\0';
//      userList[id].smtp[3][0] = '\0';
//      userList[id].sig.cmd=NULL;
//      userList[id].lastAction = 0;
//      userList[id].displayIgnore   = 0;
//      userList[id].displayInfo     = 1;
//      userList[id].displayToolTips = 1;
//      userList[id].hasNotifier = false;
//      userList[id].isNotified  = false;
//      strcpy(userList[id].color,"#000000");
//      strcpy(userList[id].color2,"#000000");
//      userList[id].socket =-1;
//      userList[id].rsocket =-1;
//      userList[id].direction_dateRemind =0;
//      userList[id].direction_dateInvite =0;
//      userList[id].direction_todoRemind =0;
//      userList[id].direction_todoMahn   =0;
//      userList[id].idSetMax=0;
//      userList[id].idSetAnz=0;
//      userList[id].set = NULL;
//      userList[id].dontList =0;
//      strcpy(userList[id].calFormat,"7 20 3 3 3 2");
//      userList[id].presence =false;
//      strcpy(userList[id].browser,"minkowsky");
//      userList[id].browserCmd[0]='\0';

//      initDateUserModification(&userList[id]);
//      userList[id].dmodiDirty = false;
    }
   else if(userAnz>=0)
    {
     if(strncmp(buffer,"FULL",4)==0)
      {
       s=skip2nonWS(buffer+4);
       strcpy(userList[id].full,s);
      }
     if(strncmp(buffer,"MAIL ",5)==0)
      {
       s=skip2nonWS(buffer+4);
       strcpy(userList[id].mail[0],s);
      }
     if(strncmp(buffer,"MAIL2",5)==0)
      {
       s=skip2nonWS(buffer+4);
       strcpy(userList[id].mail[1],s);
      }
     if(strncmp(buffer,"MAIL3",5)==0)
      {
       s=skip2nonWS(buffer+4);
       strcpy(userList[id].mail[2],s);
      }
     if(strncmp(buffer,"MAIL4",5)==0)
      {
       s=skip2nonWS(buffer+4);
       strcpy(userList[id].mail[3],s);
      }
     if(strncmp(buffer,"SMTP ",5)==0)
      {
       s=skip2nonWS(buffer+4);
       strcpy(userList[id].smtp[0],s);
      }
     if(strncmp(buffer,"SMTP2",5)==0)
      {
       s=skip2nonWS(buffer+4);
       strcpy(userList[id].smtp[1],s);
      }
     if(strncmp(buffer,"SMTP3",5)==0)
      {
       s=skip2nonWS(buffer+4);
       strcpy(userList[id].smtp[2],s);
      }
     if(strncmp(buffer,"SMTP4",5)==0)
      {
       s=skip2nonWS(buffer+4);
       strcpy(userList[id].smtp[3],s);
      }
     if(strncmp(buffer,"DONTLIST",8)==0)
      {
       userList[id].dontList=1;
      }
     if(strncmp(buffer,"COLOR",5)==0)
      {
       s=skip2nonWS(buffer+6);
       anz=split(s,tp,256);
       
       strcpy(userList[id].color ,tp[0]);
       strcpy(userList[id].color2,tp[1]);
      }
    else if (strncmp(buffer,"GROUPS",2)==0)
      {
       s=skip2nonWS(buffer+7);
       
       anz=split(s,tp,256);
       for(i=0;i<anz; i++)
	{
	 gid=gname2gid(trimRight(tp[i]));
	 if(gid>=0)
	  {
	   userList[id].groups[gc]=gid;
	   gc++;
	   userList[id].groups[gc]=-1;
	   groupList[gid].membr[groupList[gid].anz]=id;
	   groupList[gid].anz++;
	   groupList[gid].mstat[groupList[gid].anz]=GROUP_MEMBER;
	  }
	}
       userList[id].groups[gc]=-1;
       userList[id].ganz =gc;
      }
    }
   t = fgets(buffer,16383,fp);
   chop(buffer);
  }
 rewind(fp);
  t = fgets(buffer,16383,fp);
 chop(buffer);
 while(strcmp(buffer,"EOL")!=0 && t!=NULL)
  {
   if(strncmp(buffer,"ID",2)==0)
    {
     id = atoi(buffer+3);
    }
   if(strncmp(buffer,"GETNOTIFY4",10)==0)
    {
     int nc=0;
     s=skip2nonWS(buffer+11);
     
     anz=split(s,tp,256);
     for(i=0;i<anz; i++)
      {
       uid = uname2uid(trimRight(tp[i]));
       if(uid>0)
	{
	 userList[id].notified4[nc] = uid;
	 userList[uid].hasNotifier  =true;
	 userList[uid].notifierAnz  =0;
	 nc++;
	}
      }
     if(nc>0)
      userList[id].isNotified = true;
     userList[id].notified4[nc]=-1;
    }
   t = fgets(buffer,16383,fp);
   chop(buffer);
  }
 

 fclose(fp);

 for(id=0;id<=userAnz;id++)
  readUserPrefs(id);

}


void initRoom(int id, char *name)
{
 strcpy(roomList[id].name,name);
 roomList[id].id=id;
 roomList[id].cal.list = new (Date *) [DATEBLOCKSIZE];
 roomList[id].cal.max = DATEBLOCKSIZE;
 roomList[id].cal.anz = 0;
 roomList[id].calPerm = defRoomCalPerm;

}

void readRooms ()
{
 FILE *fp;
 char file[4096],buffer[16384],*t,*s;
 int ret,id;

 sprintf(file,"%s/rooms",dataDir);
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 
 roomAnz=maxID(fp)+1;
 roomList =  new Room [roomAnz+1];
 for(id=0;id<roomAnz;id++)
  roomList[id].id=-1;

 switch(serverLang)
  {
  case MINKO_LANG_DE:   initRoom(0,"auswrts");
   break;
  case MINKO_LANG_EN:  
  default:             initRoom(0,"external");
   break;
  }

 t = fgets(buffer,16383,fp);
 chop(buffer);
 while(strcmp(buffer,"EOL")!=0 && t!=NULL)
  {
   if(strncmp(buffer,"ID",2)==0)
    {
     id = atoi(buffer+3);
     s=skip2WS(buffer+3);
     s=skip2nonWS(s);
     initRoom(id,s);
//      strcpy(roomList[id].name,s);
//      roomList[id].id=id;
//      roomList[id].cal.list = new (Date *) [DATEBLOCKSIZE];
//      roomList[id].cal.max = DATEBLOCKSIZE;
//      roomList[id].cal.anz = 0;
//      roomList[id].calPerm = defRoomCalPerm;
     
    }
   else if(roomAnz>=0)
    {
     if (strncmp(buffer,"PERM",2)==0)
      {
       s=skip2nonWS(buffer+4);
       s[9]='\0';
       roomList[id].calPerm = perm2val(s);
      }
     else if (strncmp(buffer,"DETAILS",2)==0)
      {
       s=skip2nonWS(buffer+8);
       strcpy(roomList[id].descr,s);
      }
    }
   t = fgets(buffer,16383,fp);
   chop(buffer);
  }
 fclose(fp);
}

int readHoliDays ()
{
 FILE *fp;
 char file[4096],buffer[16384],*t,*s;
 int i,lines=0;

 sprintf(file,"%s/holidays",dataDir);
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   holidayLines=0;
   return(-1);
  }
 while(fgets(buffer,16000,fp)!=NULL)
  lines++;


 rewind(fp);
 holidays= new (char *) [ lines+4];

 i=0;
 while(fgets(buffer,16000,fp)!=NULL)
  {
   holidays[i] = new char [strlen(buffer)+4];
   strcpy(holidays[i],trimRight(buffer));
   i++;
   if(i>lines)
    break;
  }
 holidayLines =i;
 printf("got %d holidaylines from %s\n",holidayLines,file);
 fclose(fp);
}

int getFullUserName (int socket,char *s)
{
 int uid;
 char buffer[256],*tp[8];
 
 split(s,tp,8);
 uid=uname2uid(tp[0]);

 if(uid<0)
  {
   send2Client(socket,"{No such user}");
   return(-1);
  }
 sprintf(buffer,"{%s}",userList[uid].full);
 send2Client(socket,buffer);
}

int getGroupsOfUser (int socket,char *s)
{
 int uid,i;
 char buffer[16384],*tp[8];
 
 split(s,tp,8);
 uid=uname2uid(tp[0]);
 // printf("'%s' -> %d\n",tp[0],uid);
 if(uid<0)
  {
   send2Client(socket,"{No such user}");
   return(-1);
  }
 groupsOfUser(uid,buffer);
 send2Client(socket,buffer);
}
char * groupsOfUser(int uid,char *buffer)
{
 int i;
 sprintf(buffer,"");
 for(i=0;i<userList[uid].ganz;i++)
  if(userList[uid].groups[i]>=0)
   {
    strcat(buffer,groupList[userList[uid].groups[i]].name);
    strcat(buffer," ");
   }
  else
   break;
 return(buffer);
}

int getUsersOfGroup (int socket,char *s)
{
 int gid,i;
 char buffer[16384],*tp[8],tx[256];
 
 split(s,tp,8);
 gid=gname2gid(tp[0]);
 // printf("'%s' -> %d\n",tp[0],uid);
 if(gid<0)
  {
   send2Client(socket,"ERR {No such Group}");
   return(-1);
  }
 sprintf(buffer,"");
 for(i=0;i<groupList[gid].anz;i++)
  {
   sprintf(tx,"{%s } ",userList[groupList[gid].membr[i]].name);
   strcat(buffer,tx);
  }
 send2Client(socket,buffer);
}

int compUserNameList (const void *np1 , const void *np2)
{
 int i1, i2;
 char *n1,*n2;
 
 i1 = *((int *)np1);
 i2 = *((int *)np2);
 if (  userList[i1].id == i1)
  n1 = userList[i1].name;
 else
  n1 = "zzzzzzzzzzzzzzzzzzzzz";
 if (  userList[i2].id == i2)
  n2 = userList[i2].name;
 else
  n2 = "zzzzzzzzzzzzzzzzzzzzz";
 return(strcmp(n1,n2));
}

int getLists (int socket)
{
 char *t,*buffer,tx[4096];
 int i,hl=0,j;
 int *ulist;

 ulist =  new int [userAnz +4];
 for(i=0;i<=userAnz; i++)
  ulist[i]=i;

 for(i=0;i<holidayLines;i++)
  hl+= (strlen(holidays[i]) +4);

 qsort(ulist,userAnz+1,sizeof(int *),compUserNameList);

 buffer= new char [userAnz*99 + groupAnz*32 + roomAnz*64 +hl +16];
 strcpy(buffer,"{");


 for(i=0;i<= userAnz;i++)
  if(userList[ulist[i]].id==ulist[i])
   {
    strcat(buffer,userList[ulist[i]].name);
    strcat(buffer," ");
   }
 strcat(buffer,"} {");

 for(i=0;i<=groupAnz;i++)
  if(groupList[i].id==i)
   {
    strcat(buffer,groupList[i].name);
    strcat(buffer," ");
   }
 strcat(buffer,"} {");

 for(i=0;i<=roomAnz;i++)
  if(roomList[i].id==i)
   {
    sprintf(tx,"{%s} ",roomList[i].name);
    strcat(buffer,tx);
   }
 strcat(buffer,"} {");

 for(i=0;i<=userAnz;i++)
  if(userList[ulist[i]].id==ulist[i])
   {
    sprintf(tx,"{%s} ",userList[ulist[i]].full);
    strcat(buffer,tx);
   }
 strcat(buffer,"} {");

 for(i=0;i<holidayLines;i++)
  {
   sprintf(tx,"{%s} ",holidays[i]);
   strcat(buffer,tx);
  }
 strcat(buffer,"}                                            { ");
 for(i=0;i<=groupAnz;i++)
  if(groupList[i].id==i)
   {
    strcat(buffer,"{ ");
    strcat(buffer,groupList[i].name);
    strcat(buffer," { ");
    for (j=0; j<groupList[i].anz; j++)
     {
      strcat(buffer,userList[groupList[i].membr[j]].name);
      strcat(buffer," ");
     }
    strcat(buffer,"}} ");
   }
 strcat(buffer,"} {");

 for(i=0;i<=userAnz;i++)
  if(userList[ulist[i]].id==ulist[i])
   {
    sprintf(tx,"{%s %s} ",userList[ulist[i]].color,userList[ulist[i]].color2);
    strcat(buffer,tx);
   }
 strcat(buffer,"} {");

 for(i=0;i<=groupAnz;i++)
  if(groupList[i].id==i)
   {
    strcat(buffer,groupList[i].color);
    strcat(buffer," ");
   }
 strcat(buffer,"} {");

 for(i=0;i<=userAnz;i++)
  if(userList[i].dontList  ==1)
   {
    strcat(buffer," u-");
    strcat(buffer,userList[i].name);
   }
   
 for(i=0;i<=groupAnz;i++)
  if(groupList[i].dontList  ==1)
   {
    strcat(buffer," g-");
    strcat(buffer,groupList[i].name);
   }
 for(i=0;i<=roomAnz;i++)
  if(roomList[i].dontList  ==1)
   {
    strcat(buffer," r-");
    strcat(buffer,roomList[i].name);
   }
 strcat(buffer,"} {");
 strcat(buffer,company);
 strcat(buffer,"} {");
 strcat(buffer,groupList[primGroup].name);
 strcat(buffer,"}");
 



 send2Client(socket,buffer);
 delete buffer;
 delete ulist;
}

int getGroupMembersList (int socket)
{
 char *buffer,tx[256],txt[8192];
 int i,j,c=0;
 int *ulist;

 
 for(i=0;i<=userAnz;i++)
  if(userList[i].id==i)
   c+= userList[i].ganz+1;
 for(i=0;i<=groupAnz;i++)
  if(groupList[i].id==i)
   c += groupList[i].anz +1;

 buffer= new char [c*32+64];



 ulist =  new int [userAnz +4];
 for(i=0;i<=userAnz; i++)
  ulist[i]=i;

 qsort(ulist,userAnz,sizeof(int *),compUserNameList);
 sprintf(buffer,"%d {",ulistUpdateTim);
 // strcpy(buffer,"{");
 for(i=0;i<=userAnz;i++)
  if(userList[ulist[i]].id==ulist[i])
   {
    sprintf(txt,"{%s {",userList[ulist[i]].name);
    for(j=0;j<userList[ulist[i]].ganz; j++)
     {
      sprintf(tx,"%s ",groupList[userList[ulist[i]].groups[j]].name);
      strcat(txt,tx);
     }
    strcat(txt,"}} ");
    strcat(buffer,txt);
    }
 strcat(buffer,"} {");


 for(i=0;i<=groupAnz;i++)
  if(groupList[i].id==i)
   {
    sprintf(txt,"{%s {",groupList[i].name);
    for(j=0;j<groupList[i].anz; j++)
     {
      sprintf(tx,"%s ",userList[groupList[i].membr[j]].name);
      strcat(txt,tx);
     }
    strcat(txt,"}} ");
    strcat(buffer,txt);
   }
 strcat(buffer,"}");
 send2Client(socket,buffer);
 delete buffer;
}

int getUserList (int socket)
{
 char *t,*buffer;
 int i;
 int *ulist;

 ulist =  new int [userAnz +4];
 for(i=0;i<=userAnz; i++)
  ulist[i]=i;

 qsort(ulist,userAnz,sizeof(int *),compUserNameList);

 buffer= new char [userAnz*99];
 strcpy(buffer,"");
 for(i=0;i<=userAnz;i++)
  if(userList[ulist[i]].id==ulist[i])
   {
    strcat(buffer,userList[ulist[i]].name);
    strcat(buffer," ");
   }
 send2Client(socket,buffer);
 delete buffer;
}

int getGroupList (int socket)
{
 char *t,*buffer;
 int i;

 buffer= new char [groupAnz*32];
 strcpy(buffer,"");
 for(i=0;i<=groupAnz;i++)
  {
   printf("%d: %s %d\n",i,groupList[i].name,groupList[i].id);

   if(groupList[i].id==i)
    {
     strcat(buffer,groupList[i].name);
     strcat(buffer," ");
    }
  }
 send2Client(socket,buffer);
 delete buffer;
}
int getRoomList (int socket)
{
 char *t,*buffer,tx[64];
 int i;

 buffer= new char [roomAnz*64];
 strcpy(buffer,"");
 for(i=0;i<=roomAnz;i++)
  {
   if(roomList[i].id==i)
    {
     sprintf(tx,"{%s} ",roomList[i].name);
     strcat(buffer,tx);
    }
  }
 send2Client(socket,buffer);
 delete buffer;
}

void checkPresence()
{
 FILE *fp;
 char *t,line[256];
 int uid;

 if(doCheckPresence)
  {
   for(uid=0;uid<=userAnz;uid++)
    userList[uid].presence=false;

   presenceList[0]='\0';
   fp =fopen(checkPresenceFile,"r");
   if(fp!=NULL)
    {
     t=fgets(line,255,fp);
     do
      {
       uid = uname2uid(strTrim(line));
       if(uid>=0)
	{
	 userList[uid].presence =true;
	 strcat(presenceList," ");
	 strcat(presenceList,userList[uid].name);
	}
       t=fgets(line,255,fp);
      }while(t != NULL);
     printf("->prensecelIst: '%s'\n",presenceList);
    }
   fclose(fp);
  }
}
int getPresence (int socket)
{
 if(doCheckPresence)
  send2Client(socket,presenceList);
 else
  send2Client(socket,"??? unchecked");
}


void clearUserSelection() 
{
 int uid;
 for(uid=0;uid<=userAnz; uid++)
  if(userList[uid].id>=0)
   userList[uid].selected =false;
}
void clearGroupSelection() 
{
 int gid;
 for(gid=0;gid<=groupAnz; gid++)
  if(groupList[gid].id>=0)
   groupList[gid].selected =false;
}

int maxID(FILE *fp)
{
 char *t,buffer[16383];
 int id,maxID=-1;

 t = fgets(buffer,16383,fp);
 while(strcmp(buffer,"EOL")!=0 && t!=NULL)
  {
   if(strncmp(buffer,"ID",2)==0)
    {
     id = atoi(buffer+3);
     if(id>maxID)
      maxID=id;
    }
   t = fgets(buffer,16383,fp);
  }
 rewind(fp);
 return(maxID);
}
int gname2gid(char *name)
{
 int gid;
 for(gid=0;gid<=groupAnz; gid++)
  if(groupList[gid].id>=0)
   if(strcmp(groupList[gid].name,name)==0)
    return(gid);
 return(-1);
}
char * gid2gname(int gid)
{
 if(0<=gid && gid<groupAnz)
  if(groupList[gid].id>=0)
   return(groupList[gid].name);
 return(unknownID);
}
int uname2uid(char *name)
{
 int uid;
 for(uid=0;uid<=userAnz; uid++)
  if(userList[uid].id>=0)
   if(strcmp(userList[uid].name,name)==0)
    return(uid);
 return(-1);
}

char * uid2uname(int uid)
{
 if(0<=uid && uid<userAnz)
  if(userList[uid].id>=0)
   return(userList[uid].name);
 return(unknownID);
}
char * uid2Fullname(int uid)
{
 if(0<=uid && uid<userAnz)
  if(userList[uid].id>=0)
   return(userList[uid].full);
 return(unknownID);
}
int rname2rid(char *name)
{
 int rid;
 for(rid=0;rid<=roomAnz; rid++)
  if(roomList[rid].id>=0)
   if(strcmp(roomList[rid].name,name)==0)
    return(rid);
 return(-1);
}
char * rid2rname(int rid)
{
 if(0<=rid && rid<roomAnz)
  if(roomList[rid].id>=0)
   return(roomList[rid].name);
 return(unknownID);
}

int name2FullID(char *name)
{
 char *nam = name+2;
 int id=-1;

 if(name[0] == 'u')
  {
   if( (id = uname2uid(trimRight(nam))) <0)
    return -1;
  }
 else if(name[0] == 'g')
  {
   if( (id = gname2gid(trimRight(nam))) <0)
    return -1;
   id += GROUPOFFSET;
  }
 else if(name[0] == 'r')
  {
   if( (id = rname2rid(trimRight(nam))) <0)
    return -1;
   id += ROOMOFFSET;
  }
 return id;
}

