//  File: utils.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <27-Oct-2002 21:05:16 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>  
#include <time.h>  
#include <unistd.h>  
#include <stdarg.h>      

#include "termin.h"

extern FILE *fpl;


// String skipping operation 




char *skip2nonWS(char *t)
{
 while(*t==' ' || *t== '\t')
  {
   if(*t=='\n' || *t=='\0')
    return(NULL);
   t++;
  }
 if(*t=='\n' || *t=='\0')
  return(NULL);
 return(t);
}
char *skip2WS(char *t)
{
 while(*t!=' ' && *t!= '\t')
  {
   if(*t=='\n' || *t=='\0')
    return(NULL);
   t++;
  }
 return(t);
}

char *skip2nonWSnl(char *t)
{
 while(*t==' ' || *t== '\t')
  {
   if( *t=='\0')
    return(NULL);
   t++;
  }
 if( *t=='\0')
  return(NULL);
 return(t);
}
char *skip2WSnl(char *t)
{
 while(*t!=' ' && *t!= '\t')
  {
   if( *t=='\0')
    return(NULL);
   t++;
  }
 return(t);
}

// String manipulation operations

void chop(char *t)
{
 char *s;
 s=t+strlen(t)-1;
 while(*s== '\n' || *s == '\r' || *s == '\0')
  s--;
 s++;
 *s='\0';
}
char * strChop(char *t)
{
 char *s;
 s=t+strlen(t)-1;
 while(*s== '\n' || *s == '\r' || *s == '\0')
  s--;
 s++;
 *s='\0';
 return (t);
}

int strChopLen(const char *t)
{
 char *s;
 if(strlen(t)==0)
  return (0);
 s = new char [strlen(t)+2];
 strcpy(s,t);
 return(strlen(strChop(s)));
}

// Convert all {} into ()

char *replaceBraces(char *t)
{
 char *s;

 for(s=t; *s!='\0'; s++)
  {
   if(*s=='{')
    *s='(';
   else if (*s=='}')
    *s=')';
  }
 return(t);
}


// Strign analysis
int split(char *txt,char **tp ,int max)
{
 int sc=0,bc=0,qc=0;
 int i=0,anz;
 char *s,*t;

 s=skip2nonWS(txt);
 if(s==NULL)
  tp[0]=txt;
 else
  {
   tp[i]=s;
   i++;

   for(t=s; *t!='\0'; t++)
    {
     // Alle "" '' {}-Blcke dedektieren
     if(sc==0 && qc==0) // In Quotes und strings nicht nach {}-Blcken suchen
      {
       if(*t=='{')
	bc++;
       if(*t=='}')
	bc--;
      }
     if(*t=='"')
      sc =sc ^1;

     if(sc==0 && qc==0 && bc==0)// In "" '' {}-Blcken  nicht nach WS suchen
      if(*t==' ' || *t=='\t')
       {
	if(t==s)             // Falls t auf den Nachfolger des letzten tp zeigt (d.h. meherer WS hinter einander
	 {                   // verschiebe den letzten tp nur , sonst lege einen neunen an
	  tp[i-1]=t;
	  s=t+1;
	 }
	else
	 {
	  tp[i]=t;
	  i++;
	  if(i==max)
	   break;
	  s=t+1;
	 }
       }	
    }
  }

 anz=i;
 for(i=0;i<anz;i++)
  {
   s=skip2nonWSnl(tp[i]);
   if(s==NULL)
    anz=i;
   else
    {
     tp[i]=s;
     s--;
     if(s>=txt)
      *s='\0';
    }
  }
 for(i=0;i<anz;i++)
  {
   s=tp[i];
   if(*s=='{')
    {
     tp[i]=s+1;
     s=strrchr(tp[i],'}');
     *s='\0';
    }
   if(*s=='"')
    {
     tp[i]=s+1;
     s=strrchr(tp[i],'"');
     *s='\0';
    }
   if(*s=='\'')
    {
     tp[i]=s+1;
     s=strrchr(tp[i],'\'');
     *s='\0';
    }
  }


 if (anz >0)
  {
   s=tp[anz-1]+strlen(tp[anz-1])-1;
   while (*s== ' ' || *s =='\t')
    s--;
   s++;
   *s='\0';
  }
 return(anz);
}


int strEditDist(char *ostr, char *nstr, int maxDiff,int penalty)
{
 int diff= strEditDist(ostr,nstr,maxDiff);
 if(diff>= maxDiff)
  return penalty;
 return(diff);
}
int strEditDist(char *ostr, char *nstr, int maxDiff)
{
 int diff=0,diff2,diff3;
 char *o=ostr,*n=nstr;

 if(maxDiff <=0 )
  return(0);
 

 while ( *o == *n )
  {
   o++;
   n++;
   if (*o == '\0' || *n == '\0')
    break;
  }
 if(*o == '\0')
  {
   if(*n== '\0')
    return(0);
   else
    {
     diff = strlen(n);
     if(diff>maxDiff)
      return(maxDiff);
     return(diff);
    }
  }
 else
  if(*n=='\0')
   {
    diff = strlen(o);
    if(diff>maxDiff)
     return(maxDiff);
    return(diff);
   }
 

 if(n[1]!='\0' && o[1] !='\0')
  diff  = strEditDist(o+1,n+1,maxDiff-1) +1;
 else 
  diff = maxDiff;
 if(o[1] !='\0')
  diff2 = strEditDist(o+1,n  ,maxDiff-1) +1;
 else 
  diff2 = maxDiff;
 if(n[1] !='\0')
  diff3 = strEditDist(o  ,n+1,maxDiff-1) +1;
 else 
  diff3 = maxDiff;

 if(diff>diff2)
  diff=diff2;
 if(diff>diff3)
  diff=diff3;

 return(diff);
}


// Date manipulation



char *date2Str(int datum, int tim,char *t)
{
 int day,mon,year,hour,min;
 
 year = datum /10000;
 mon  = (datum%10000) /100;
 day  = datum %100;
 hour = tim /100;
 min  = tim %100;
 
 sprintf(t,"%2d.%2d.%4d, %2d:%02d Uhr",day,mon,year,hour,min);
 return(t);
}
char *date2Str(int datum, char *t)
{
 int day,mon,year,hour,min;
 
 year = datum /10000;
 mon  = (datum%10000) /100;
 day  = datum %100;
 
 sprintf(t,"%2d.%2d.%4d",day,mon,year);
 return(t);
}
char *time2Str(int tim,char *t)
{
 int day,mon,year,hour,min;
 
 hour = tim /100;
 min  = tim %100;
 
 sprintf(t,"%2d:%02d Uhr",hour,min);
 return(t);
}

int weekDayByDate(int datum)
{
 struct tm tm,*tmp;
 int tim;

 tm.tm_mday = datum %100;
 tm.tm_mon  = (datum%10000)/100 -1;
 tm.tm_year = datum /10000-1900;
 tm.tm_hour = 12;
 tm.tm_min  =tm.tm_sec =0;
 tmp=&tm;
 tim = mktime(&tm);
 tmp =localtime((const time_t *)&tim);
 return((tmp->tm_wday+6) %7);
}

int calcDate (int *datum, int *tim, int offset, int offset2 , int unit)
{
 int day,mon,year,hour,min;
 int monLen[13]={0,31,28,31,30,31,30,31,31,30,31,30,31},feb;
 struct tm tms;

 // printf("shift %d, %d  by %d/%d %c to \t",*datum,*tim,offset,offset2,unit);

 year = *datum /10000;
 mon  = (*datum%10000) /100;
 day  = *datum %100;
 hour = *tim /100;
 min  = *tim %100;
 
 switch (unit)
  {
  case 'm': 
   min  += offset; 
   break;
  case 'h': 
   hour += offset;
   min  += offset2;
   break;
  case 'd':
   day  += offset;
   hour += offset2;
   break;
  case 'w' :
   day  += offset*7 + offset2;
   break;
  case 'M' :
   mon  += offset;
   day  += offset2;
   break;
  case 'y' :
   year += offset;
   mon  += offset2;
   break;

  default:
   return(false);
  }



 while(min < 0)
  {
   min+=60;
   hour  --;
  }
 while(min>60)
  {
   min-=60;
   hour++;
  }
 while(hour<0)
  {
   hour += 24;
   day --;
  }
 while(hour >=24)
  {
   hour -=24;
   day++;
  }
 while(day<0)
  {
   mon--;
   if(mon<0)
    {
     mon=12;
     year--;
    }
   day += monLen[mon];
   if(mon ==2)
    if( (year %4) == 0)
     day ++;
  }
 

 while (mon>12)
  {
   mon-=12;
   year++;
  }

 if(mon==2 && (year %4)==0)
  feb=1;
 else
  feb=0;

 while(day>monLen[mon]+feb)
  {
   day -= (monLen[mon]+feb);
   mon++;
   if(mon==2 && (year %4)==0)
    feb=1;
   else
    feb=0;
   
   if(mon>12)
    {
     year++;
     mon=1;
    }
  }

 *datum = year*10000+mon*100+day;
 *tim   = 100*hour+min;
 return(true);
}

int getWeekDayInMonth(int *weekCount, int *wday,int datum)
{
 struct tm tms,*tmp;
 int tim,day;

 tms.tm_sec =  0;
 tms.tm_min =  0;
 tms.tm_hour= 12;
 tms.tm_mday= day = datum %100;
 tms.tm_mon = (datum%10000) /100 -1;
 tms.tm_year= datum /10000-1900;

 tim = mktime(&tms);
 tmp = localtime((const time_t*) &tim);
 
 *wday = (tmp->tm_wday+6)%7;
 *weekCount = (int)floor( (day-0.5)/7.);
}

int getCountedWeekDayDatum(int weekCount, int wday, int datum)
{
 struct tm tms,*tmp;
 int dw,w1day,day,tim;

 tms.tm_sec =  0;
 tms.tm_min =  0;
 tms.tm_hour= 12;
 tms.tm_mday= 1;
 tms.tm_mon = (datum%10000) /100 -1;
 tms.tm_year= datum /10000-1900;
 tim = mktime(&tms);
 tmp = localtime((const time_t*) &tim);

 w1day = (tmp->tm_wday+6) % 7;
 dw    = (wday -w1day +7) % 7;
 day   = dw + weekCount*7 + 1;   // Die 1 , da der Refere4bnz tag der 1. des Monats ist
 datum = datum -datum %100 + day;
 return(datum);
}


int calcDateBackward (int datum, int tim, int offset , int offset2, int unit)
{
 int day,mon,year,hour,min;
 int monLen[13]={0,31,28,31,30,31,30,31,31,30,31,30,31};
 struct tm tms;
 time_t ntim;

 year = datum /10000;
 mon  = (datum%10000) /100;
 day  = datum %100;
 hour = tim /100;
 min  = tim %100;

//  if(verbose)
//   printf("calcBack: %2d.%2d.%4d %2d:%02d  by %d %d %c\t",day,mon,year,hour,min,offset,offset2,unit);

 switch (unit)
  {
  case 'm': 
   min  -= offset; 
   break;
  case 'h': 
   hour -= offset;
   min  -= offset2;
   break;
  case 'd':
   day  -= offset;
   hour -= offset2;
   break;
  default:
   return(0);
  }

 while(min < 0)
  {
   min+=60;
   hour  --;
  }
 while(hour<0)
  {
   hour += 24;
   day --;
  }
 while(mon<1)
  {
   mon+=12;
   year --;
  }
 while(day<0)
  {
   mon--;
   if(mon<0)
    {
     mon=12;
     year--;
    }
   day += monLen[mon];
   if(mon ==2)
    if( (year %4) == 0)
     day ++;
  }

//  if(verbose)
//   printf("-> %2d.%2d.%4d %2d:%02d  \t",day,mon,year,hour,min);

 tms.tm_sec =  0;
 tms.tm_min =min;
 tms.tm_hour=hour;
 tms.tm_mday=day;
 tms.tm_mon =mon-1;
 tms.tm_year=year-1900;

 ntim =mktime(&tms);
//  if(verbose)
//   printf("-> %d\n",ntim);
 
 return(ntim);
}
int calcDateForward (int datum, int tim, int offset , int offset2, int unit)
{
 int day,mon,year,hour,min;
 int monLen[13]={0,31,28,31,30,31,30,31,31,30,31,30,31};
 struct tm tms;

 year = datum /10000;
 mon  = (datum%10000) /100;
 day  = datum %100;
 hour = tim /100;
 min  = tim %100;

 switch (unit)
  {
  case 'm': 
   min  += offset; 
   break;
  case 'h': 
   hour += offset;
   min  += offset2;
   break;
  case 'd':
   day  += offset;
   hour += offset2;
   break;
  default:
   return(0);
  }

 while(min >60)
  {
   min-=60;
   hour++;
  }
 while(hour>23)
  {
   hour -= 24;
   day ++;
  }
 while(mon>12)
  {
   mon-=12;
   year++;
  }
 while(day>monLen[mon])
  {
   day -= monLen[mon];
   if(mon ==2)
    if( (year %4) == 0)
     day --;
   mon++;
   if(mon>12)
    {
     mon=1;
     year++;
    }
  }

 tms.tm_sec =  0;
 tms.tm_min =min;
 tms.tm_hour=hour;
 tms.tm_mday=day;
 tms.tm_mon =mon-1;
 tms.tm_year=year-1900;

 
 return(mktime(&tms));
}
int nextExportTime(int hour, int min)
{
 char tstr[64];
 struct tm tms,*lt;
 time_t tim=time(NULL);
 time_t nxt;

 lt  = localtime(&tim);
 tms.tm_sec =  0;
 tms.tm_min =min;
 tms.tm_hour=hour;
 tms.tm_mday=strftime(tstr,255,"%d",lt);
 tms.tm_mon =strftime(tstr,255,"%m",lt);
 tms.tm_year=strftime(tstr,255,"%Y",lt);

 nxt = mktime(&tms);
 while(nxt<tim)
  nxt += 24*3600;

 return(nxt);
}


void backupData()
{
 struct tm *lt;
 time_t tim=time(NULL);
 char cmd [4096];
 char path[1000];
 char tstr[64];

 lt  = localtime(&tim);

 if(lt->tm_hour == permanentBackupHour)
  {
   strftime(tstr,255,"%Y-%m-%d",localtime(&tim));
   sprintf(path,"%s/%s",backupPath, tstr);
  }
 else
  sprintf(path,"%s/%02d",backupPath,lt->tm_hour);
 minkoLog("writing backup to %s\n",path);
 sprintf(cmd,"%s/backupMinkowsky.sh %s %s",serverBinPath,dataDir,path);
 system(cmd);
 

}

// othrs

void getToday ( )
{
 char tstr[64];
 time_t tim=time(NULL);
 strftime(tstr,255,"%Y%m%d",localtime(&tim));0;   
 today=atoi(tstr);
}

int minkoLog(const char *fmt, ...)
{
 va_list ap;
 char txt[256];

 if(fpl == NULL)
  return(0);

 va_start(ap, fmt);

 time_t tim=time(NULL);
 strftime(txt,255,"%Y%m%d %H %M %S",localtime(&tim));0;   
 fprintf(fpl,"%s: ",txt);
 fflush(fpl);
 
 vfprintf(fpl,fmt,ap);
 fflush(fpl);
 va_end(ap);   
}


int makeServerID( char *t)
{
 FILE *fp;
 char s[3],in[16];
 
 s[2]='\0';
 sprintf(in,"%08X",time(NULL));

 fp =fopen("/dev/random","r");
 s[0]= ((char) fgetc(fp) & 63)+32;
 s[1]= ((char) fgetc(fp)& 63)+32;
 fclose(fp);
 strcpy(t,crypt(in,s)+2);
 return true;
}

